////////////////////////////////////////////////////////////
//
//    RUH KAPANI v0.1
//
//    Mehmet Deniz Aydinoglu . 2004
//    (deniz@oyunyapimi.org)
//
//    Lisans: GPL (license.txt)
//
//    www.oyunyapimi.org
//
////////////////////////////////////////////////////////////

#ifndef __UI_h__
#define __UI_h__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "glfont.h"

#include <windows.h>
#include "gl/gl.h"
#include <sdl/sdl.h>

#include <lib3d/util2d/Texture.h>

#include <list>
#include <vector>
using namespace std;

class UIWidget;
class UILabel;
class UIMultiLineLabel;
class UIBanner;
class UIGfxMenu;
class UIManager;
class UIEvent;

typedef list<UIWidget*>    WidgetList;
typedef vector<UILabel*>   LabelVector;
typedef vector<UIBanner*>  BannerVector;
typedef vector<UIGfxMenu*> MenuVector;


//----------------- class UIEvent ----------------- 

// Arayuz elamanlari (widget) tarafindan olusturulan event lar bu sinif
// ile tasinmaktadir. type ile eventin tipi belirtilir. source pointeri eventi
// ureten nesneyi gosterirken, data elemani icerisinde varsa event source tarafindan
// geri yollanan ekstra bilgiler bulabilir.

class UIEvent {
public:
   
   enum UIEventType { UIEVT_UNKNOWN=0,
      UIEVT_UIEDIT_EDITISFULL, UIEVT_UIEDIT_ENTERPRESSED, UIEVT_UIEDIT_ESCPRESSED,
      UIEVT_UIEDIT_ORDINARYKEYPRESSED,
      UIEVT_UILABEL_ENTERPRESSED, UIEVT_UILABEL_UPDOWNKEYPRESSED,
      UIEVT_UIBANNER_ENTERPRESSED, UIEVT_UIBANNER_UPDOWNKEYPRESSED,
      UIEVT_UIMENU_ITEMSELECTED,
      UIEVT_UIGFXMENU_ONITEM, UIEVT_UIGFXMENU_ITEMSELECTED
   };
   
   UIEvent(UIEventType t,UIWidget *s,unsigned int d) { type = t; source = s; data = d; }

      
   UIEventType type;
   UIWidget *source;
   unsigned int data;

};

//----------------- class UIWidget ----------------- 

// Arayuz elemanlari widget olarak adlandirilir. Tum button lar, label lar
// menuler , hepsi widget dan turemistir.
// UIMAnager sinifi tum widgetlari ortak bir listede tutar.
// render sirasinda render() fonksiyonu cagirilir. Bir tusa basilma durumunda
// ise focus halindeki widgetin onKeyEvent yordami tetiklenir.
// UIWidget sinifindan tureyen diger siniflar onKeyEvent ve render fonksiyonlarini
// gerceklestirmek zorundadirlar.

class UIWidget {

   friend class UIManager;
   friend class UIPanel;

public:

   enum eWidgetType { WT_LABEL=0, WT_MLABEL, WT_BANNER, WT_MENU, WT_GMENU, WT_EDIT, WT_PANEL };
   
   UIWidget() { timet = 0; visible = true; focused = false; id = -1; }
   ~UIWidget() {}

   void setPos(float nx,float ny) { x = nx; y = ny; }
   void getPos(float *nx,float *ny) { *nx = x; *ny = y; }
   void setVisible(bool v) { visible = v; }
   bool isVisible() { return visible; }
   eWidgetType getType() { return wtype; }
   int  getID() { return id; };
   void setID(int id) { this->id = id; }
   bool isFocused() { return focused; }
   const char* print();
   
   virtual UIEvent onKeyEvent(const SDLKey &key) { return UIEvent(UIEvent::UIEVT_UNKNOWN,this,0); }
   virtual void update(float dt) { timet += dt; }
   virtual void render() = 0;
   
protected:
   
   virtual void setFocus(bool f) { focused = f; if (f) visible = true; }

   int   id;
   float timet;
   float x,y;
   bool  visible;
   bool  focused;     // only focused widgets receive keyboard events!
   eWidgetType wtype;

};


//----------------- class UILabel ----------------- 

// Bu widget ile ekranda bir text goruntulenebilir.
// Text in rengi degistirilebilir.

class UILabel : public UIWidget {

public:
   UILabel(const char *txt,float x,float y);

   virtual void setText(const char *txt);
   virtual void setText(float val);
   void setColor(float r,float g,float b) { colr = r; colg = g; colb = b; }
   const char* getText() { return text; };

   virtual void render();
   virtual UIEvent onKeyEvent(const SDLKey &key);

   float colr,colg,colb;

protected:
   char text[256];
   
};

//----------------- class UIMultiLineLabel ----------------- 

// Bu widget ile ekranda cok satirli bir text goruntulenebilir.

class UIMultiLineLabel : public UILabel {

public:
   UIMultiLineLabel(const char *txt,float x,float y,float yspacing=10.1f);

   virtual void setText(const char *txt);
   virtual void render();

protected:
   char lines[100][64];
   int  lineCount;
   float yspacing;

};

//----------------- class UIBanner ----------------- 

// Bu sinif ile bir banner (texture) goruntulenebilir.
// Goruntulenen texture in boyutlari degistirilebilir.

class UIBanner : public UIWidget {

public:
   UIBanner(const char *texturename,float x,float y,float szx,float szy);

   virtual void render();
   virtual UIEvent onKeyEvent(const SDLKey &key);

protected:
   Texture *tex;
   float szx,szy;

};

//----------------- class UIMenu ----------------- 

// Bu sinif ile cokdan secilmi bir text menu olusturulabilir.
// menu elemanlari basit UILabel nesneleridir.
// O anda secili olan menu elemaninin kontrol edilmesi ve tusa basilmalara
// gore degistirilmesi bu sinif tarafindan saglanir.

class UIMenu : public UIWidget {

public:
   UIMenu() {
      wtype = WT_MENU;
      currSelectedItem = 0;
      selected_item_col[0] = 0.9f; selected_item_col[1] = 0.2f; selected_item_col[2] = 0.2f;  
   };

   void addItem(const char *txt,float x,float y);
   void selectItem(int idx) { if (idx < labels.size()) currSelectedItem = idx; }
   int  getSelectedItem() { return currSelectedItem; }
   void setSelectedItemColor(float r,float g,float b) {
      selected_item_col[0] = r; selected_item_col[1] = g; selected_item_col[2] = b;
   }
   
   virtual UIEvent onKeyEvent(const SDLKey &key);
   virtual void update(float dt);
   virtual void render();

protected:
   LabelVector labels;
   int currSelectedItem;

   float selected_item_col[3];
   float selected_item_prev_col[3];
  


};

//----------------- class UIGfxMenu ----------------- 

// UIMenu ye benzer ama elemnlari basit text ler yerine grafiklerdir.
// Bu grafikleri UIBanner listesinde tutar.

class UIGfxMenu : public UIWidget {

public:
   UIGfxMenu() { wtype = WT_GMENU; currSelectedItem = 0; selectorBanner = NULL; };

   void addItem(UIBanner *unselected, UIBanner *selected);
   void selectItem(int idx) { if (idx < selectedBanners.size()) currSelectedItem = idx; }
   int  getSelectedItem() { return currSelectedItem; };
   void setSelectorBanner(UIBanner *sbanner) { selectorBanner = sbanner; };

   virtual UIEvent onKeyEvent(const SDLKey &key);
   virtual void update(float dt);
   virtual void render();

protected:
   BannerVector selectedBanners;
   BannerVector unselectedBanners;
   int currSelectedItem;

   UIBanner *selectorBanner;
   
};

//----------------- class UIEdit ----------------- 

// Kullanicinin girdi yapabilecegi bir nesne.
// Oyunda kullanici adinini almak icin kullanilmaktadir.

class UIEdit : public UILabel {

public:
   UIEdit(const char *txt="") : UILabel(txt,0,0) { wtype = WT_EDIT; setText(txt); epressed = false; max_chars=255; };

   const char* getText() { return text; };
   bool  isEnterPressed() { return epressed; };
   void  resetEnter() { epressed = false; };
   void  setMaxChars(int mc) { max_chars = mc; };

   virtual UIEvent onKeyEvent(const SDLKey &key);
   virtual void render();

protected:
   bool epressed;
   int max_chars;

};

//----------------- class UIPanel ----------------- 

// Bu widget bir gorsellige sahip degildir. Diger widget lari gruplamak
// icin kullanilir. Bu sayede tum bir widget setinin pozisyonunu degistirmek,
// gorselligini acip-kapamak gibi fonksiyonlar kolaylikla gerceklestirilebilmektedir.

class UIPanel : public UIWidget {

public:
   UIPanel() { wtype = WT_PANEL; setPos(0,0); focusedWidget = NULL; };

   UIWidget* addWidget(UIWidget *w);   
   UIWidget* getFocusedWidget() { return focusedWidget; };

   virtual UIEvent onKeyEvent(const SDLKey &key);
   virtual void update(float dt);
   virtual void render();

protected:

   void setFocus(bool f);

   WidgetList widgets;
   UIWidget *focusedWidget;

};


//----------------- Interface class UIOwner ----------------- 

// App sinifi bir UIOwner dir (multiple inheritance)
// Bu sayede widget lardan kaynaklanan eventler app ye iletilebilmektedir.

class UIOwner {
public:
   virtual void UIEvent_Callback(UIEvent *event) {};
};


//----------------- class UIManager ----------------- 

// Tum arayuzun kontrolu bu sinif tarafinda saglaniyor.
// Arayuzu olusturan elemanlar addXXX() fonksiyonlari ile sisteme ekleniyor.
// Bu elemanlar (widget lar) bir liste icerisinde tutuluyor.
// focusWidget() fonksiyonu ile bir widget in aktif olmasi saglanabiliyor.
// Sadece aktif widget klavye eventlerinden etkileniyor.
// Widget lardan gelen eventler ise owner elemanina iletiliyor.
// Ruh kapaninda owner olarak tanimlanan sinif App oldugu icin gerekli
// eventleri bu sinif aliyor.
// render() fonksiyonu ile tum widget larin render leri cagiriliyor ve
// cizim islemi yapiliyor. update() de ise yine tum widget lar icin update()
// yordamlari cagirliyor.

class UIManager {

public:
   UIManager(UIOwner *owner=NULL);
   ~UIManager();

   void init();
   void update(float dt);
   void keyEvent(const SDLKey &key);
   void render();

   void setVisible(bool vis) { visible = vis; }
   void setOwner(UIOwner *owner) { this->owner = owner; }
   void addWidget(UIWidget *w);
   UILabel* addLabel(const char *text,float x,float y);
   UIMenu*  addMenu();
   void     addCustomMenu(UIMenu *menu);
   UIGfxMenu* addGfxMenu();
   UIEdit*    addEdit();
   UIPanel*   addPanel();

   void focusWidget(UIWidget *w);

protected:
   GLFONT glf;

   WidgetList widgets;  // labels, banners etc..
   UIWidget *focusedWidget;   // keyboard event receiver..
   UIOwner *owner;

   int  freeid_counter;
   bool visible;

};

//----------------- class MyUILabel ----------------- 

class MyUILabel : public UILabel {
public:
   MyUILabel(const char *txt,float x,float y,float w,float h) : UILabel(txt,x,y) {
      back_col[0] = 0.2f; back_col[1] = 0.5f; back_col[2] = 0.2f; back_col[3] = 0.5f;
      border_col[0] = 0.2f; border_col[1] = 0.3f; border_col[2] = 0.2f;
      
      bwidth = w;
      bheight = h;
   }

   virtual void render();
   
   float border_col[3];
   float back_col[4];
   float bwidth,bheight;

};

//----------------- class MyUIPanel ----------------- 

class MyUIPanel : public UIPanel {
public:
   MyUIPanel(float x,float y,float w,float h) {
      back_col[0] = 0.2f; back_col[1] = 0.5f; back_col[2] = 0.2f; back_col[3] = 0.5f;
      border_col[0] = 0.2f; border_col[1] = 0.3f; border_col[2] = 0.2f;
      
      setPos(x,y);
      
      bwidth = w;
      bheight = h;
   }

   virtual void render();
   
   float border_col[3];
   float back_col[4];
   float bwidth,bheight;

};

//----------------- class MyUIMenu ----------------- 

class MyUIMenu : public UIMenu {
public:
   MyUIMenu(const char *caption,float x,float y,float w,float h);
   ~MyUIMenu() {
   }

   virtual void render();
   
   float border_col[3];
   float back_col[4];
   float bwidth,bheight;
      
protected:
   MyUIPanel *menuPanel;

   

};


#endif